function [sd_eps,sd_eta,tau]=stockwatson(y)%,var_eps_min,var_eta_min);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Code for computing the permanent-transitory decomposition in Stock     %
%-Watson, JMCB, 2007, by MCMC.                                          %
%Written by Mark Watson in Gauss (incorporating revision of May 3 2007) %
%Translated to Matlab by Jonathan Wright                                %
%Input: The inflation series                                            %
%Outputs:                                                               %
%sd_eps: Standard deviation of permanent component                      %
%sd_eta: Standard deviation of transitory component                     %
%tau: Estimated permanent component                                     % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%datainf cpitotal, cpilessFandE, medCPI, trimmean


n=length(y);
randn('seed',123); rand('seed',123);

vague = 1000;
burnin=100;
ndraw=5100;

%Parameters for log-chi-squared errors%
r_p=.086;
r_m1=-7.472;
r_m2=-0.698;
r_sig2=1.411;
r_sig=sqrt(r_sig2);

%Parameters for RW Innovation Variance%
tau1=.20;  
tau2=.20;  
q_p=1.0;     %Prob of Regime 1...note that here we are always in regime 1, but it could be otherwise.
q1=tau1^2;
q2=tau1^2;

params=[r_p;r_m1;r_m2; r_sig; r_sig2;q_p;q1;q2;tau1;tau2;vague];


%Parameters for Initial Conditions, bounds and so forth%
    tau0=mean(y(1:4));  %average of first few observations
    dy=y(2:end)-y(1:end-1);
    var_dy = (std(dy))^2;
%Lower Bounds on variances			%
% these are needed to keep algorith away from boundary   %
%    -- the values are problem specific: these seem to work well for the US	%
    var_eta_min = 0.015*var_dy;
    var_eps_min = 0.005*var_dy;
 

%Initial Values				%
    var_eps_initial = var_dy/3;
    var_eta_initial = var_dy/3;

sprintf('Estimate of tau0 %10.4f',tau0);
sprintf('Lower bound on SD eta %10.4f',sqrt(var_eta_min));
sprintf('Lower bound on SD eps %10.4f',sqrt(var_eps_min));
sprintf('Initial guess of sd_eta %10.4f',sqrt(var_eta_initial));
sprintf('Initial guess of sd_eps %10.4f',sqrt(var_eps_initial));

   y=y-tau0; % Eliminate intial value of tau from analysis 
   r_pt_eps = r_p*ones(n,1);
   q_pt_eps = q_p*ones(n,1);
    r_pt_eta = r_p*ones(n,1);
    q_pt_eta = q_p*ones(n,1);
    var_eps_n = var_eps_initial*ones(n,1);
    var_eta_n = var_eta_initial*ones(n,1);
    
    sd_eps_save=zeros(n,ndraw-burnin);
    sd_eta_save=zeros(n,ndraw-burnin);
    tau_save=zeros(n,ndraw-burnin);
for idraw=1:ndraw;
    idraw
[eps,eta,tau]=draw_eps_eta(y,var_eps_n,var_eta_n);
[var_eps_n,r_pt_eps,q_pt_eps]=draw_var(eps,r_pt_eps,q_pt_eps,var_eps_min,params);
[var_eta_n,r_pt_eta,q_pt_eta]=draw_var(eta,r_pt_eta,q_pt_eta,var_eta_min,params);  
     if idraw > burnin;
      sd_eps_n=sqrt(var_eps_n);
      sd_eta_n=sqrt(var_eta_n);
      sd_eps_save(:,idraw-burnin)=sd_eps_n;
      sd_eta_save(:,idraw-burnin)=sd_eta_n;     
      tau_save(:,idraw-burnin)=tau;
     end;
end;
   
sd_eps=zeros(n,1); sd_eta=zeros(n,1); tau=zeros(n,1);
for i=1:n;
sd_eps(i)=median(sd_eps_save(i,:));  %Could change these from medians into means or other percentiles
sd_eta(i)=median(sd_eta_save(i,:));
tau(i)=median(tau_save(i,:));
end;

tau=tau+tau0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


